//------------------------------------------------------------------------------
//! @file CRC16.h
//! @ingroup Utils
//! <!------------------------------------------------------------------------->
//! @brief CRC16 Declarations
//! @version 0.2
//! <!------------------------------------------------------------------------->
//!
//! Declarations for 16-BIT CRC CCITT calculation
//!
//! <!--------------------------------------------------------------------------
//! Copyright (c) 2009
//! IMST GmbH
//! Carl-Friedrich Gauss Str. 2-4
//! 47475 Kamp-Lintfort
//! --------------------------------------------------------------------------->
//! @author (KvW), IMST
//! <!--------------------------------------------------------------------------
//! Target OS:    independent
//! Target CPU:   independent
//! Compiler:     tbd
//! --------------------------------------------------------------------------->
//! @internal
//! @par Revision History:
//! <PRE>
//! ----------------------------------------------------------------------------
//! Version | Date       | Author | Comment
//! ----------------------------------------------------------------------------
//! 0.1     | 28.08.1997 | KvW    | Created
//! 0.2     | 14.09.2011 | KvW    | cleanup
//! </PRE>
//------------------------------------------------------------------------------

#ifndef    __CRC16_H__
#define    __CRC16_H__

//------------------------------------------------------------------------------
//
//  Section Include Files
//
//------------------------------------------------------------------------------

#include <inttypes.h>
//! @cond Doxygen_Suppress
typedef uint8_t     UINT8;
typedef uint16_t    UINT16;
//! @endcond
//------------------------------------------------------------------------------
//
//  Section Defines
//
//------------------------------------------------------------------------------

#define CRC16_INIT_VALUE    0xFFFF    //!< initial value for CRC algorithem
#define CRC16_GOOD_VALUE    0x0F47    //!< constant compare value for check
#define CRC16_POLYNOM       0x8408    //!< 16-BIT CRC CCITT POLYNOM

//------------------------------------------------------------------------------
// C++ Extensions
//------------------------------------------------------------------------------
#ifdef   __cplusplus
extern  "C" {
#endif
//------------------------------------------------------------------------------
//
//  Section Prototypes
//
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
//! Calc CRC16
UINT16
CRC16_Calc  (UINT8*     data,
             UINT16     length,
             UINT16     initVal);
//------------------------------------------------------------------------------
//! Calc & Check CRC16
bool
CRC16_Check (UINT8*     data,
             UINT16     length,
             UINT16     initVal);

//------------------------------------------------------------------------------
// C++ Extensions
//------------------------------------------------------------------------------
#ifdef    __cplusplus
}
#endif
//------------------------------------------------------------------------------

#endif // __CRC16_H__
//------------------------------------------------------------------------------
// end of file
//------------------------------------------------------------------------------
