#include <DS1337.h>
#include <avr/sleep.h>
// How long do we expect bouncing of the reed switch or another button to happen?
#define BOUNCE_MS 10 

int SWITCH_PIN = 3; // pin 3 (INT1 of Stalker V3) connected to tipping bucket rain gauge reed switch
int RTC_PIN = 2;    // pin 2 (INT0 of Stalker V3) for RTC alarm
int counts = 0;

volatile boolean switchEvent = false; // a interrupt on low state occurred
volatile boolean rtcEvent = false; // a interrupt on low state occurred
volatile boolean isActivated = true; // important for the enterSleep function
DS1337 RTC;
#define SD_CS_PIN SS
#include <SPI.h>
#include <SdFat.h>
SdFat SD;

File myFile;
File myFile2;

#include <SoftwareSerial.h>

const byte rxPin = 6; // connected to BEE_TXD, jumper P6.
const byte txPin = 7; // connected to BEE_RXD, jumper P5. Attention: Fix HW bug.

SoftwareSerial mySerial (rxPin, txPin);

void setup() {
  // put your setup code here, to run once:
  pinMode(SWITCH_PIN, INPUT_PULLUP);
  pinMode(RTC_PIN, INPUT_PULLUP);


  Serial.begin(9600);
  mySerial.begin(9600);
  //Serial.println("lets start");
  //mySerial.print("+++");
  
 // Serial.println("Count button press events.");  
  //Serial.println("Press button.");  
  Serial.flush();

  RTC.begin();
  RTC.clearINTStatus();
  RTC.enableInterrupts(EveryMinute);

  isActivated = true;
  switchEvent = false;
  
  attachInterrupt(1,isr_switch,LOW); // INT1 connected to reed switch of rain gauge
  attachInterrupt(0,isr_rtc, LOW);  // INT0 connected to onboard RTC DS1337

  //Serial.print("Initializing SD card...");
  
  pinMode(10, OUTPUT);

  if (!SD.begin(SD_CS_PIN)) {
    Serial.println("initialization failed!");
    return;
  }
  Serial.println("initialization done.");

 
 // Alarm.timerRepeat(15, Repeats);            // timer for every 15 seconds    


}

void loop() {

  if (switchEvent)
  {
    switchEvent = false;
    delay(BOUNCE_MS); // primitive debounce function, high -> low
    while (!digitalRead(SWITCH_PIN)); // Block program, just loop until a high occurs. 
    delay(BOUNCE_MS); // primitive debounce function, low -> high
    counts++;
    //Serial.print("Count: "); Serial.println(counts);
    Serial.flush();
    attachInterrupt(1,isr_switch,LOW);  
  }

  if (rtcEvent)
  {
   rtcEvent = false;    
   RTC.clearINTStatus();
   delay(20);
   WritingData();
   Writingseconddata();
   SendingData();
   attachInterrupt(0,isr_rtc,LOW);
   counts = 0;  
  }

  enterSleep();
     
}    

void isr_switch(void)
{
  if (isActivated)
  {
    detachInterrupt(1);
    switchEvent = true;
    }
}

void isr_rtc()
{
  if (isActivated)
  {
  //Keep this as short as possible. Possibly avoid using function calls
   detachInterrupt(0);
   rtcEvent = true;
  }
}



void enterSleep()
{
  detachInterrupt(1);
  detachInterrupt(0);

  set_sleep_mode(SLEEP_MODE_PWR_DOWN);
  sleep_enable();

  isActivated = false;
  attachInterrupt(1,isr_switch,LOW);
  attachInterrupt(0,isr_rtc,LOW);
  
  sleep_mode();
  
  // Sleeping ... ZZZ ... ZZZ ...ZZZ ...
  
  sleep_disable();
  isActivated = true; // don't forget to activate the code in the ISR again!}
}

void WritingData()
{
  
   DateTime now = RTC.now();
   myFile = SD.open("temp.txt", FILE_WRITE);    //write the data into temporary file
     if (myFile) {
      //Serial.print("Writing to temp.txt...");
      myFile.print("N1;");
      myFile.print(now.year(), DEC);
      myFile.print('-');
      myFile.print(now.month(), DEC);
      myFile.print('-');
      myFile.print(now.date(), DEC);
      myFile.print(' ');
      myFile.print(now.hour(), DEC);
      myFile.print(':');
      myFile.print(now.minute(), DEC);
      myFile.print(':');
      myFile.print(now.second(), DEC);
      myFile.print(";");
      myFile.print("TB1");
      myFile.print(";");
      myFile.print(counts);
      myFile.println("#");
      // close the file:
      myFile.close();
      //Serial.println("done.");
    } else {
      // if the file didn't open, print an error:
      Serial.println("error opening temp.txt");
    }

}

void Writingseconddata()
{
  DateTime now = RTC.now();
   myFile2 = SD.open("data.txt", FILE_WRITE);    //write the data into back-up file
     if (myFile2) {
      //Serial.print("Writing to test.txt...");
      myFile2.print("N1;");
      myFile2.print(now.year(), DEC);
      myFile2.print('-');
      myFile2.print(now.month(), DEC);
      myFile2.print('-');
      myFile2.print(now.date(), DEC);
      myFile2.print(' ');
      myFile2.print(now.hour(), DEC);
      myFile2.print(':');
      myFile2.print(now.minute(), DEC);
      myFile2.print(':');
      myFile2.print(now.second(), DEC);
      myFile2.print(";");
      myFile2.print("TB1");
      myFile2.print(";");
      myFile2.print(counts);
      myFile2.println("#");
      // close the file:
      myFile2.close();
      //Serial.println("done.");
    } else {
      // if the file didn't open, print an error:
      Serial.println("error opening test.txt");
    }
  
}

void SendingData()
{
    DateTime now = RTC.now();
    if (mySerial.available()>0){  
       if(now.minute()%2==0){
        if (!myFile.open("temp.txt")) { 
              SD.errorHalt("opening temp.txt for read failed");
            }
            
            // read from the temporary file until there's nothing else in it:
            int data;
            while ((data = myFile.read()) >= 0) {
              mySerial.write(data);
            }
            // remove the temporary file:
            if (!myFile.remove()) Serial.println("Error file.remove");           
        }
    }
}

